############### ###############
## F_H2_A_game_group_contrib
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

  ggplot(CBO_groups_final_IND %>% 
           drop_na(A_game_group_contrib, contributions_late) %>% 
           group_by(appcode) %>% #Taking the CBO-level average
           mutate(A_game_group_contrib = mean(A_game_group_contrib, na.rm = T)) %>% 
           ungroup() %>%
           distinct(appcode, .keep_all = T) %>% #Putting it at the CBO level
           filter(reshaped_id == "A_game_groupcontrib_1"), 
         
         aes(x = A_game_group_contrib)) +
    geom_histogram(binwidth = 0.01) +
    labs(x = "Voluntary contribution as proportion of endowment.", 
         y = "Percentage share of CBO members") + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H2_", "A_game_group_contrib.png"), device = png,  dpi=200)

